
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='grains', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='vegetables', lb=0, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(0.40 * x1 + 0.60 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(30 * x1 + 15 * x2 >= 100, name='iron_requirement')
    model.addConstr(5 * x1 + 25 * x2 >= 150, name='fiber_requirement')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: grains = {x1.varValue}, vegetables = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
