
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("basketball_shots")

# Create variables
long_shots = m.addVar(vtype=GRB.INTEGER, name="long_shots")
mid_range_shots = m.addVar(vtype=GRB.INTEGER, name="mid_range_shots")

# Set objective function
m.setObjective(0.25 * long_shots + 0.40 * mid_range_shots, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * long_shots + 2 * mid_range_shots >= 95, "score_constraint")
m.addConstr(long_shots >= 5, "min_long_shots")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Number of long shots: {long_shots.x}")
    print(f"Number of mid-range shots: {mid_range_shots.x}")
    print(f"Total efficiency: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

