
from gurobipy import *

# Create a new model
m = Model("Basketball_Shots")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="long_shots_made")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="mid_range_shots_made")

# Set objective function to minimize total shots made
m.setObjective(x1 + x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 >= 95, "score_requirement")
m.addConstr(x1 >= 5, "min_long_shots")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Long shots made: {x1.x}")
    print(f"Mid-range shots made: {x2.x}")
else:
    print("No optimal solution found")
