
import gurobi as gp

# Create a new model
m = gp.Model("Basketball_Optimization")

# Define variables
x1 = m.addVar(name="long_shots", lb=5, vtype=gp.GRB.INTEGER)  # At least 5 long shots
x2 = m.addVar(name="mid_range_shots", lb=0, vtype=gp.GRB.INTEGER)  # Non-negative mid-range shots

# Objective function: Maximize 0.75x1 + 0.80x2
m.setObjective(0.75*x1 + 0.80*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*0.25*x1 + 2*0.4*x2 >= 95, name="score_constraint")

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal long shots: {x1.varValue}")
    print(f"Optimal mid-range shots: {x2.varValue}")
    print(f"Max Efficiency: {m.objVal}")
else:
    print("The problem is infeasible")
