
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("paper_production")

# Create variables
lined_paper = m.addVar(vtype=GRB.CONTINUOUS, name="lined_paper")
unlined_paper = m.addVar(vtype=GRB.CONTINUOUS, name="unlined_paper")

# Set objective function
m.setObjective(5 * lined_paper + 3 * unlined_paper, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * lined_paper + 1 * unlined_paper <= 400, "printing_constraint")
m.addConstr(5 * lined_paper + 2 * unlined_paper <= 400, "scanning_constraint")
m.addConstr(lined_paper >= 0, "non_negativity_lined")
m.addConstr(unlined_paper >= 0, "non_negativity_unlined")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Reams of lined paper: {lined_paper.x}")
    print(f"Reams of unlined paper: {unlined_paper.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

