
from gurobipy import *

# Create a new model
m = Model("Paper_Production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="lined_paper")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="unlined_paper")

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + x2 <= 400, "printing_machine")
m.addConstr(5*x1 + 2*x2 <= 400, "scanning_machine")
m.addConstr(x1 >= 0, "non_negative_lined")
m.addConstr(x2 >= 0, "non_negative_unlined")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lined paper: {x1.x} reams")
    print(f"Unlined paper: {x2.x} reams")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
