
import gurobi

def solve_paper_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0, ub=gurobi.GRB.INFINITY, obj=5)  # reams of lined paper
    x2 = model.addVar(name="x2", lb=0, ub=gurobi.GRB.INFINITY, obj=3)  # reams of unlined paper

    # Add constraints
    model.addConstr(x1 * 2 + x2 <= 400, name="printing_constraint")
    model.addConstr(x1 * 5 + x2 * 2 <= 400, name="scanning_constraint")

    # Set objective function
    model.setObjective(x1 * 5 + x2 * 3, gurobi.GRB.MAXIMIZE)

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production: {x1.varValue} reams of lined paper, {x2.varValue} reams of unlined paper")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_paper_production_problem()
