
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
solar_acres = m.addVar(lb=0, name="solar_acres")
windmill_acres = m.addVar(lb=0, name="windmill_acres")

# Set objective function
m.setObjective(500 * solar_acres + 1000 * windmill_acres, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(solar_acres + windmill_acres <= 120, "land_constraint")
m.addConstr(20 * solar_acres + 40 * windmill_acres <= 2000, "resource_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Solar Panels: {solar_acres.x}")
    print(f"Acres of Windmills: {windmill_acres.x}")
    print(f"Total Savings: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

