
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_solar_panels")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_windmills")

# Set the objective function
m.setObjective(500*x1 + 1000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 120, "total_land")
m.addConstr(20*x1 + 40*x2 <= 2000, "total_resources")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of solar panels: {x1.x}")
    print(f"Acres of windmills: {x2.x}")
    print(f"Maximum savings: {m.objVal}")
else:
    print("No optimal solution found")
