
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0, ub=gurobi.GRB.INFINITY)  # acres of solar panels
    x2 = model.addVar(name='x2', lb=0, ub=gurobi.GRB.INFINITY)  # acres of windmills

    # Set the objective function
    model.setObjective(500 * x1 + 1000 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 120, name='land_constraint')
    model.addConstr(20 * x1 + 40 * x2 <= 2000, name='resource_constraint')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Max savings: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
