
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Advertising_Optimization")

# Create variables
planes = m.addVar(vtype=GRB.INTEGER, name="planes")
blimps = m.addVar(vtype=GRB.INTEGER, name="blimps")
balloons = m.addVar(vtype=GRB.INTEGER, name="balloons")

# Set objective function
m.setObjective(100000 * planes + 50000 * blimps + 20000 * balloons, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5000 * planes + 2000 * blimps + 1000 * balloons <= 50000, "Budget")
m.addConstr(planes <= 5, "Plane_Limit")
m.addConstr(balloons <= 0.5 * (planes + blimps + balloons), "Balloon_Limit")
m.addConstr(blimps >= 0.2 * (planes + blimps + balloons), "Blimp_Minimum")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Viewership: {m.objVal}")
    print(f"Number of Plane Ads: {planes.x}")
    print(f"Number of Blimp Ads: {blimps.x}")
    print(f"Number of Hot Air Balloon Ads: {balloons.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

