
import gurobipy as gp
from gurobipy import GRB

def solve_advertisement_problem():
    # Create a new model
    model = gp.Model("advertisement_problem")

    # Define variables
    x1 = model.addVar(name="ads_on_planes", vtype=GRB.INTEGER, lb=0)
    x2 = model.addVar(name="ads_on_blimps", vtype=GRB.INTEGER, lb=0)
    x3 = model.addVar(name="ads_on_hot_air_balloons", vtype=GRB.INTEGER, lb=0)

    # Objective function: Maximize viewership
    model.setObjective(100000*x1 + 50000*x2 + 20000*x3, GRB.MAXIMIZE)

    # Cost constraint
    model.addConstr(5000*x1 + 2000*x2 + 1000*x3 <= 50000, name="cost_constraint")

    # Ad limit per platform
    model.addConstr(x1 <= 5, name="plane_limit")
    model.addConstr(x2 <= 5, name="blimp_limit")
    model.addConstr(x3 <= 5, name="hot_air_balloon_limit")

    # Hot air balloon limit
    model.addConstr(x3 <= x1 + x2, name="hot_air_balloon_vs_others")

    # Blimp minimum
    model.addConstr(0.8*x2 - 0.2*x1 - 0.2*x3 >= 0, name="blimp_minimum")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Ads on planes: {x1.varValue}")
        print(f"Ads on blimps: {x2.varValue}")
        print(f"Ads on hot air balloons: {x3.varValue}")
        print(f"Max viewership: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_advertisement_problem()
