
import gurobipy as gp

# Create a new model
model = gp.Model("energy_drinks")

# Create variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # cans of energy drink R
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # cans of energy drink M


# Set objective function
model.setObjective(4*x1 + 7*x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x1 + 5*x2 >= 30, "caffeine_req")
model.addConstr(5*x1 + 8*x2 >= 50, "water_req")
model.addConstr(x1 >= 0, "nonneg_x1")
model.addConstr(x2 >= 0, "nonneg_x2")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Optimal cost: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

