
from gurobipy import *

# Create a new model
m = Model("Energy_Drinks")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2", lb=0)

# Set the objective function
m.setObjective(4*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 5*x2 >= 30, "caffeine_constraint")
m.addConstr(5*x1 + 8*x2 >= 50, "water_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cans of energy drink R: {x1.x}")
    print(f"Number of cans of energy drink M: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
