
import gurobi

def solve_energy_drink_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.INTEGER)  # cans of energy drink R
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.INTEGER)  # cans of energy drink M

    # Define the objective function
    model.setObjective(4 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(2 * x1 + 5 * x2 >= 30, name="caffeine_requirement")
    model.addConstr(5 * x1 + 8 * x2 >= 50, name="water_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

solve_energy_drink_problem()
