
import gurobipy as gp

# Create a new model
model = gp.Model("Paint_Production")

# Create variables
oil_paint = model.addVar(nonnegative=True, name="oil_paint")  # x1
acrylic_paint = model.addVar(nonnegative=True, name="acrylic_paint") # x2
watercolor_paint = model.addVar(nonnegative=True, name="watercolor_paint") # x3


# Set objective function
model.setObjective(150 * oil_paint + 180 * acrylic_paint + 220 * watercolor_paint, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6.5 * oil_paint + 8 * acrylic_paint + 16 * watercolor_paint <= 350, "Dye_Constraint")
model.addConstr(15 * oil_paint + 12 * acrylic_paint + 5 * watercolor_paint <= 250, "Filler_Constraint")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Oil paint production: {oil_paint.x:.2f} kg")
    print(f"Acrylic paint production: {acrylic_paint.x:.2f} kg")
    print(f"Watercolor paint production: {watercolor_paint.x:.2f} kg")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

