
import gurobi

def solve_paint_manufacturer_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="oil_paintings", lb=0, ub=None)
    x2 = model.addVar(name="acrylic_paintings", lb=0, ub=None)
    x3 = model.addVar(name="watercolor_paintings", lb=0, ub=None)

    # Define the objective function
    model.setObjective(150 * x1 + 180 * x2 + 220 * x3, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(6.5 * x1 + 8 * x2 + 16 * x3 <= 350, name="dye_constraint")
    model.addConstr(15 * x1 + 12 * x2 + 5 * x3 <= 250, name="filler_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oil paintings: {x1.varValue} kg")
        print(f"Acrylic paintings: {x2.varValue} kg")
        print(f"Watercolor paintings: {x3.varValue} kg")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_paint_manufacturer_problem()
