
import gurobipy as gp

# Create a new model
m = gp.Model("coffee_optimization")

# Create variables
vanilla = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vanilla")  # Packages of Vanilla
mocha = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mocha")  # Packages of Mocha

# Set objective function
m.setObjective(2 * vanilla + 3 * mocha, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * vanilla + 3 * mocha >= 60, "caffeine_constraint")
m.addConstr(2 * vanilla + 5 * mocha >= 50, "sugar_constraint")
m.addConstr(vanilla >= 0, "vanilla_nonnegative")
m.addConstr(mocha >= 0, "mocha_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Vanilla packages: {vanilla.x:.2f}")
    print(f"Mocha packages: {mocha.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

