
from gurobipy import *

# Create a new model
m = Model("Coffee_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Vanilla")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Mocha")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 >= 60, "Caffeine_Constraint")
m.addConstr(2*x1 + 5*x2 >= 50, "Sugar_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vanilla packages: {x1.x}")
    print(f"Mocha packages: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
