
import gurobi as gp

# Create a new model
model = gp.Model("Coffee_Optimization")

# Define the variables
x1 = model.addVar(name="Vanilla", lb=0, vtype=gp.GRB.INTEGER)  # Number of Vanilla packages
x2 = model.addVar(name="Mocha", lb=0, vtype=gp.GRB.INTEGER)   # Number of Mocha packages

# Define the objective function
model.setObjective(2*x1 + 3*x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(2*x1 + 3*x2 >= 60, name="Caffeine_Constraint")  # Caffeine constraint
model.addConstr(2*x1 + 5*x2 >= 50, name="Sugar_Constraint")    # Sugar constraint

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
