
import gurobipy as gp

# Create a new model
m = gp.Model("gift_optimization")

# Create variables
postal_pickups = m.addVar(vtype=gp.GRB.INTEGER, name="postal_pickups")
vans = m.addVar(vtype=gp.GRB.INTEGER, name="vans")

# Set objective function
m.setObjective(100 * postal_pickups + 80 * vans, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(50 * postal_pickups + 40 * vans <= 1000, "budget_constraint")
m.addConstr(vans <= postal_pickups, "van_pickup_constraint")
m.addConstr(postal_pickups >= 0, "non_negativity_postal")
m.addConstr(vans >= 0, "non_negativity_vans")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of postal pickups: {postal_pickups.x}")
    print(f"Number of vans: {vans.x}")
    print(f"Total gifts sent: {100 * postal_pickups.x + 80 * vans.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

