
from gurobipy import *

# Create a new model
m = Model("Gift_Sending_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="postal_service_pickups")
x2 = m.addVar(vtype=GRB.INTEGER, name="vans_hired")

# Set the objective function
m.setObjective(100*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 40*x2 <= 1000, "Budget_Constraint")
m.addConstr(x2 <= x1, "Vans_vs_Pickups_Constraint")
m.addConstr(x1 >= 0, "Non_Negativity_x1")
m.addConstr(x2 >= 0, "Non_Negativity_x2")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Number of postal service pickups: {x1.x}")
    print(f"Number of vans hired: {x2.x}")
    print(f"Total gifts sent: {100*x1.x + 80*x2.x}")
else:
    print("No optimal solution found.")
