
import gurobi

def solve_gift_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="postal_pickups", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="vans_hired", vtype=gurobi.GRB.INTEGER, lb=0)

    # Define the objective function
    model.setObjective(100*x1 + 80*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(50*x1 + 40*x2 <= 1000, name="budget_constraint")
    model.addConstr(x2 <= x1, name="vans_vs_pickups_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of postal pickups: {x1.varValue}")
        print(f"Number of vans hired: {x2.varValue}")
        print(f"Total gifts sent: {100*x1.varValue + 80*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_gift_store_problem()
