
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Supplement_Optimization")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Supplement_A") # Supplement A
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Supplement_B") # Supplement B


# Set objective function
m.setObjective(3.5 * x1 + 3.8 * x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x1 + 4 * x2 >= 25, "Calcium_req")
m.addConstr(2 * x1 + 1 * x2 >= 20, "Vitamin_A_req")
m.addConstr(3 * x1 + 2 * x2 >= 18, "Vitamin_B_req")
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Number of Supplement A: {x1.x:.2f}")
    print(f"Number of Supplement B: {x2.x:.2f}")

