
from gurobipy import *

# Create a new model
m = Model("Supplement_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Supplement_A")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Supplement_B")

# Set the objective function
m.setObjective(3.50*x1 + 3.80*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 >= 25, "Calcium_Requirement")
m.addConstr(2*x1 + x2 >= 20, "Vitamin_A_Requirement")
m.addConstr(3*x1 + 2*x2 >= 18, "Vitamin_B_Requirement")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Supplement A: {x1.x}")
    print(f"Supplement B: {x2.x}")
    print(f"Total Cost: ${3.50*x1.x + 3.80*x2.x:.2f}")
else:
    print("No optimal solution found")
