
import gurobi

def solve_supplement_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Supplement A
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Supplement B

    # Define the objective function
    model.setObjective(3.50 * x1 + 3.80 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 4 * x2 >= 25, name="calcium_constraint")
    model.addConstr(2 * x1 + x2 >= 20, name="vitamin_A_constraint")
    model.addConstr(3 * x1 + 2 * x2 >= 18, name="vitamin_B_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_supplement_problem()
