
import gurobipy as gp

# Create a new model
m = gp.Model("spelling_bee")

# Create variables
short_words = m.addVar(vtype=gp.GRB.INTEGER, name="short_words")
long_words = m.addVar(vtype=gp.GRB.INTEGER, name="long_words")

# Set objective function
m.setObjective(3 * short_words + 6 * long_words, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(short_words >= 5, "min_short_words")
m.addConstr(long_words >= 2, "min_long_words")
m.addConstr(short_words <= 10, "max_short_words")
m.addConstr(long_words <= 5, "max_long_words")
m.addConstr(short_words + long_words <= 10, "total_words")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal} points")
    print(f"Number of short words: {short_words.x}")
    print(f"Number of long words: {long_words.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

