
from gurobipy import *

# Create a new model
m = Model("Spelling_Bee")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="short_words")
x2 = m.addVar(vtype=GRB.INTEGER, name="long_words")

# Set the objective function
m.setObjective(3*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 5, "at_least_5_short")
m.addConstr(x2 >= 2, "at_least_2_long")
m.addConstr(x1 <= 10, "at_most_10_short")
m.addConstr(x2 <= 5, "at_most_5_long")
m.addConstr(x1 + x2 <= 10, "total_at_most_10")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Short words: {x1.x}")
    print(f"Long words: {x2.x}")
    print(f"Total points: {3*x1.x + 6*x2.x}")
else:
    print("No optimal solution found")
