
import gurobi

def solve_spelling_bee():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=10, name="short_words", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, ub=5, name="long_words", vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 3*x1 + 6*x2
    model.setObjective(3*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 5, name="min_short_words")
    model.addConstr(x2 >= 2, name="min_long_words")
    model.addConstr(x1 <= 10, name="max_short_words")
    model.addConstr(x2 <= 5, name="max_long_words")
    model.addConstr(x1 + x2 <= 10, name="total_words")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Short words: {x1.varValue}")
        print(f"Long words: {x2.varValue}")
        print(f"Points: {3*x1.varValue + 6*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_spelling_bee()
