
import gurobipy as gp

# Create a new model
m = gp.Model("ice_cream_optimization")

# Create variables
chocolate = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chocolate")
vanilla = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vanilla")


# Set objective function
m.setObjective(2 * chocolate + 1.5 * vanilla, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(chocolate >= 30, "min_chocolate")
m.addConstr(chocolate <= 50, "max_chocolate")
m.addConstr(vanilla >= 20, "min_vanilla")
m.addConstr(vanilla <= 60, "max_vanilla")
m.addConstr(chocolate + vanilla <= 70, "total_cones")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of chocolate cones: {chocolate.x}")
    print(f"Number of vanilla cones: {vanilla.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

