
from gurobipy import *

# Create a new model
m = Model("Ice_Cream_Sales")

# Define variables
x1 = m.addVar(lb=30, ub=50, name="chocolate_cones")  # Number of chocolate ice cream cones
x2 = m.addVar(lb=20, ub=60, name="vanilla_cones")    # Number of vanilla ice cream cones

# Define the objective function
m.setObjective(2*x1 + 1.5*x2, GRB.MAXIMIZE)

# Add constraint for total number of cones
m.addConstr(x1 + x2 <= 70, name="total_cones")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate ice cream cones to sell: {x1.x}")
    print(f"Vanilla ice cream cones to sell: {x2.x}")
    print(f"Total profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
