
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, ub=70, name="chocolate_ice_cream_cones", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(lb=0, ub=70, name="vanilla_ice_cream_cones", vtype=gurobi.GRB.INTEGER)

# Set the objective function
model.setObjective(2*x1 + 1.5*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 >= 30, name="min_chocolate")
model.addConstr(x1 <= 50, name="max_chocolate")
model.addConstr(x2 >= 20, name="min_vanilla")
model.addConstr(x2 <= 60, name="max_vanilla")
model.addConstr(x1 + x2 <= 70, name="total_cones")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chocolate ice cream cones: {x1.varValue}")
    print(f"Vanilla ice cream cones: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
