
import gurobipy as gp

# Create a new model
model = gp.Model("BakeryOptimization")

# Create variables
strawberry = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberry")
caramel = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="caramel")


# Set objective function
model.setObjective(1.5 * strawberry + 2 * caramel, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(strawberry >= 50, "strawberry_min")
model.addConstr(caramel >= 75, "caramel_min")
model.addConstr(strawberry <= 100, "strawberry_max")
model.addConstr(caramel <= 150, "caramel_max")
model.addConstr(strawberry >= 2 * caramel, "strawberry_caramel_ratio")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Make {strawberry.x} strawberry brownies and {caramel.x} caramel brownies")
    print(f"Maximum revenue: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists that satisfies all constraints.")
else:
    print(f"Optimization terminated with status {model.status}")

