
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="strawberry_brownies")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="caramel_brownies")

# Set the objective function
m.setObjective(1.5*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 50, "min_strawberry")
m.addConstr(x2 >= 75, "min_caramel")
m.addConstr(x1 <= 100, "max_strawberry")
m.addConstr(x2 <= 150, "max_caramel")
m.addConstr(x1 >= 2*x2, "strawberry_vs_caramel")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Strawberry Brownies: {x1.x}")
    print(f"Caramel Brownies: {x2.x}")
    print(f"Maximum Revenue: {m.objVal}")
else:
    print("No optimal solution found")
