
import gurobipy as gp

# Create a new model
model = gp.Model("Brownie_Optimization")

# Define variables
x1 = model.addVar(lb=0, ub=100, name="strawberry_brownies", vtype=gp.GRB.INTEGER)
x2 = model.addVar(lb=0, ub=150, name="caramel_brownies", vtype=gp.GRB.INTEGER)

# Objective function: Maximize 1.5*x1 + 2*x2
model.setObjective(1.5 * x1 + 2 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 >= 50, name="min_strawberry")
model.addConstr(x2 >= 75, name="min_caramel")
model.addConstr(x1 <= 100, name="max_strawberry")
model.addConstr(x2 <= 150, name="max_caramel")
model.addConstr(x1 >= 2 * x2, name="strawberry_to_caramel_ratio")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Strawberry brownies: {x1.varValue}")
    print(f"Caramel brownies: {x2.varValue}")
    print(f"Revenue: {1.5 * x1.varValue + 2 * x2.varValue}")
else:
    print("No optimal solution found.")
