
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("NecklaceProduction")

# Create variables
platinum = m.addVar(vtype=GRB.CONTINUOUS, name="platinum")  # Number of platinum necklaces
silver = m.addVar(vtype=GRB.CONTINUOUS, name="silver")  # Number of silver necklaces


# Set objective function
m.setObjective(2000 * platinum + 700 * silver, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * platinum + 7 * silver <= 35, "Designing Time")
m.addConstr(15 * platinum + 5 * silver <= 40, "Crafting Time")
m.addConstr(platinum >= 0, "Platinum Non-Negativity")  # Ensure non-negative number of necklaces
m.addConstr(silver >= 0, "Silver Non-Negativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Produce {platinum.x:.2f} platinum necklaces")
    print(f"Produce {silver.x:.2f} silver necklaces")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

