
from gurobipy import *

# Create a new model
m = Model("Necklace_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="platinum_necklaces", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="silver_necklaces", lb=0)

# Set the objective function
m.setObjective(2000*x1 + 700*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 7*x2 <= 35, "designing_team")
m.addConstr(15*x1 + 5*x2 <= 40, "crafting_team")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Platinum necklaces: {x1.x}")
    print(f"Silver necklaces: {x2.x}")
    print(f"Total profit: ${2000*x1.x + 700*x2.x:.2f}")
else:
    print("No optimal solution found.")
