
import gurobi

def solve_necklace_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='platinum_necklaces', lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='silver_necklaces', lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(2000 * x1 + 700 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x1 + 7 * x2 <= 35, name='designing_time')
    model.addConstr(15 * x1 + 5 * x2 <= 40, name='crafting_time')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Maximum profit: ${2000 * x1.x + 700 * x2.x}")
    else:
        print("The model is infeasible")

solve_necklace_problem()
