
import gurobipy as gp

# Create a new model
m = gp.Model("Capsule Mixing")

# Create variables
x1 = m.addVar(lb=0, name="Capsule A")  # Number of Capsule A
x2 = m.addVar(lb=0, name="Capsule B")  # Number of Capsule B


# Set objective function
m.setObjective(2*x1 + 3*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 >= 20, "Targeted Medicine")
m.addConstr(3*x1 + x2 >= 20, "Pain Reliever")
m.addConstr(x1 + 3*x2 >= 15, "Filler")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of Capsule A: {x1.x:.2f}")
    print(f"Number of Capsule B: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

