
from gurobipy import *

# Create a new model
m = Model("Pharmacy_Mixing_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Capsule_A")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Capsule_B")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 >= 20, "Targeted_Medicine")
m.addConstr(3*x1 + x2 >= 20, "Pain_Reliever")
m.addConstr(x1 + 3*x2 >= 15, "Filler")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Capsule A: {x1.x}, Capsule B: {x2.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
