
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x1 + 3*x2 >= 20, name="targeted_medicine")
    model.addConstr(3*x1 + x2 >= 20, name="pain_reliever")
    model.addConstr(x1 + 3*x2 >= 15, name="filler")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of capsule A: {x1.varValue}")
        print(f"Number of capsule B: {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
