
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tool_production")

# Create variables
hammers = m.addVar(vtype=GRB.INTEGER, name="hammers")
screwdrivers = m.addVar(vtype=GRB.INTEGER, name="screwdrivers")

# Set objective function
m.setObjective(72 * hammers + 70 * screwdrivers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(28 * hammers + 23 * screwdrivers <= 720, "lathe_constraint")
m.addConstr(82 * hammers + 76 * screwdrivers <= 720, "cng_constraint")
m.addConstr(hammers >=0)
m.addConstr(screwdrivers >= 0)


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Number of hammer packages: {hammers.x}")
    print(f"  Number of screwdriver packages: {screwdrivers.x}")
    print(f"  Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

