
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="hammers")
    x2 = model.addVar(lb=0, name="screwdrivers")

    # Define the objective function
    model.setObjective(72 * x1 + 70 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(28 * x1 + 23 * x2 <= 720, name="lathe_constraint")
    model.addConstr(82 * x1 + 76 * x2 <= 720, name="CNG_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of hammers: {x1.varValue}")
        print(f"Number of screwdrivers: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
