
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Chicken Transportation")

# Create variables
train_trips = m.addVar(vtype=GRB.INTEGER, name="train_trips")
truck_trips = m.addVar(vtype=GRB.INTEGER, name="truck_trips")

# Set objective function
m.setObjective(500 * train_trips + 300 * truck_trips, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100 * train_trips + 80 * truck_trips <= 2000, "budget_constraint")
m.addConstr(train_trips <= truck_trips, "trips_constraint")
m.addConstr(train_trips >= 0, "train_nonnegativity")  # Explicit non-negativity constraints
m.addConstr(truck_trips >= 0, "truck_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of train trips: {train_trips.x}")
    print(f"Number of truck trips: {truck_trips.x}")
    print(f"Total chickens transported: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

