
import gurobi

def solve_transportation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="train_trips")
    x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name="truck_trips")

    # Objective function: maximize 500*x1 + 300*x2
    model.setObjective(500*x1 + 300*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(100*x1 + 80*x2 <= 2000, name="budget_constraint")
    model.addConstr(x1 <= x2, name="train_truck_constraint")
    model.addConstr(x1 >= 0, name="non_negativity_train")
    model.addConstr(x2 >= 0, name="non_negativity_truck")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of train trips: {x1.varValue}")
        print(f"Number of truck trips: {x2.varValue}")
        print(f"Total chickens transported: {500*x1.varValue + 300*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_transportation_problem()
