
import gurobipy as gp

# Create a new model
model = gp.Model("CandyStoreOptimization")

# Create variables
fruit_gummy = model.addVar(vtype=gp.GRB.INTEGER, name="fruit_gummy")
sour_gummy = model.addVar(vtype=gp.GRB.INTEGER, name="sour_gummy")


# Set objective function
model.setObjective(1 * fruit_gummy + 1.25 * sour_gummy, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * fruit_gummy + 15 * sour_gummy <= 2000, "time_constraint")
model.addConstr(fruit_gummy <= 120, "fruit_limit")
model.addConstr(sour_gummy <= 70, "sour_limit")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Fruit gummy packets: {fruit_gummy.x}")
    print(f"Sour gummy packets: {sour_gummy.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

