
from gurobipy import *

# Create a new model
m = Model("Gummy_Bears_Production")

# Define variables
x1 = m.addVar(name='fruit_gummy_bears', lb=0)  # Number of packets of fruit gummy bears
x2 = m.addVar(name='sour_gummy_bears', lb=0)   # Number of packets of sour gummy bears

# Set the objective function
m.setObjective(1*x1 + 1.25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 2000, name='time_constraint')
m.addConstr(x1 <= 120, name='fruit_production_limit')
m.addConstr(x2 <= 70, name='sour_production_limit')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
