
import gurobi

def solve_gummy_bears_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="fruit_gummy_bears", lb=0, ub=120, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="sour_gummy_bears", lb=0, ub=70, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 1*x1 + 1.25*x2
    model.setObjective(1*x1 + 1.25*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10*x1 + 15*x2 <= 2000, name="time_constraint")
    model.addConstr(x1 <= 120, name="fruit_gummy_bears_limit")
    model.addConstr(x2 <= 70, name="sour_gummy_bears_limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Fruit gummy bears packets: {x1.varValue}")
        print(f"Sour gummy bears packets: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_gummy_bears_problem()
