
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Candy Gift Boxes")

# Create variables
mall_hours = m.addVar(vtype=GRB.CONTINUOUS, name="mall_hours")
flagship_hours = m.addVar(vtype=GRB.CONTINUOUS, name="flagship_hours")


# Set objective function
m.setObjective(150 * mall_hours + 500 * flagship_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * mall_hours + 10 * flagship_hours >= 80, "small_boxes")
m.addConstr(6 * mall_hours + 15 * flagship_hours >= 100, "medium_boxes")
m.addConstr(2 * mall_hours + 9 * flagship_hours >= 50, "large_boxes")
m.addConstr(mall_hours >=0)
m.addConstr(flagship_hours >=0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Mall kiosk hours: {mall_hours.x:.2f}")
    print(f"Flagship store hours: {flagship_hours.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

