
import gurobipy as gp

# Create a new model
model = gp.Model("Gift_Box_Production")

# Define variables
x1 = model.addVar(name="mall_kiosk_hours", lb=0)  # Hours of operation for the mall kiosk
x2 = model.addVar(name="flagship_store_hours", lb=0)  # Hours of operation for the flagship store

# Objective function: Minimize cost
model.setObjective(150 * x1 + 500 * x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(5 * x1 + 10 * x2 >= 80, name="small_gift_boxes")  # Small gift boxes constraint
model.addConstr(6 * x1 + 15 * x2 >= 100, name="medium_gift_boxes")  # Medium gift boxes constraint
model.addConstr(2 * x1 + 9 * x2 >= 50, name="large_gift_boxes")  # Large gift boxes constraint

# Solve the model
model.solve()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Mall Kiosk Hours: {x1.varValue}")
    print(f"Flagship Store Hours: {x2.varValue}")
    print(f"Total Cost: {model.objVal}")
else:
    print("No optimal solution found.")
